/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 */

const {isE2eRequest} = require('server/utilities/request/isE2eRequest');
const {getUserSplitByRequest} = require('./utils/getUserSplitByRequest');
const {mergeUserSplitWithCookie} = require('./utils/mergeUserSplitWithCookie');

const EMPTY_USER_SPLIT = {
    configVersion: '',
    experiments: {},
    testIds: '',
    rawExperiments: {},
    boxes: '',
};

/**
 * Функция добавления данных из uaas для мидлвари,
 * предполагается использование после того как в запрос проставятся флаги isStaff и isYandexNetwork
 *
 * @param {Request} req
 * @return {Promise<void>}
 */
async function setExperimentsToRequest(req) {
    try {
        /*
         * E2E тесты, без явного указания, не учитывают поведение в AB экспах.
         * Поэтому мы их отключаем для e2e
         *
         * E2E-тесты актуализируются при выпиле экспов из кода
         */
        let userSplit = isE2eRequest(req.cookies)
            ? EMPTY_USER_SPLIT
            : await getUserSplitByRequest(req);

        /**
         * Возможность ручного выставления экспериментов через куки.
         * Для эксперимента из конфига { aviaTestExperiment: 'AVIA_experiment:test' }
         * нужно поставить куку AVIA_experiment=test (document.cookie = "AVIA_experiment=test; path=/;").
         * При этом в конфиге не должен стоять принудительный флаг.
         * */
        const {isStaff, isYandexNetwork} = req.userInfo || {};

        if (isStaff || isYandexNetwork) {
            userSplit = mergeUserSplitWithCookie(userSplit, req.cookies);
        }

        req.experiments = userSplit.experiments;
        req.userSplit = userSplit;
    } catch (e) {
        req.utils.logError('Не удалось получить userSplit', e);

        req.experiments = {};
        req.userSplit = {};
    }
}

module.exports = {
    setExperimentsToRequest,
};
