/**
 * @typedef {import('../types').IExperiment} IExperiment
 */

/**
 * Восстанавливает эксперименты из base64 строки
 *
 * @param {string} rawExperiment
 * @returns {IExperiment[]}
 */
function decodeUaasRawExperiment(rawExperiment) {
    return JSON.parse(Buffer.from(rawExperiment, 'base64').toString());
}

module.exports = {
    decodeUaasRawExperiment,
};
