/**
 * @typedef {import('../types').IUaasRequestHeaders} IUaasRequestHeaders
 * @typedef {import('../types').IInitialUserSplitData} IInitialUserSplitData
 */

const {fetchUaas} = require('./fetchUaas');
const {parseUaasResponseHeaders} = require('./parseUaasResponseHeaders');

/**
 *
 * @param {string} uri
 * @param {IUaasRequestHeaders} requestHeaders
 * @returns {Promise<IInitialUserSplitData>}
 */
function getInitialUserSplitData(uri, requestHeaders) {
    return fetchUaas(uri, requestHeaders)
        .then(({headers}) => parseUaasResponseHeaders(headers))
        .catch(getInitialUserSplitFallbackData);
}

/**
 * @returns {IInitialUserSplitData}
 */
function getInitialUserSplitFallbackData() {
    return {
        rawExperiments: {},
        configVersion: '',
        testIds: '',
        encryptedExperiments: '',
        boxes: '',
    };
}

module.exports = {
    getInitialUserSplitData,
};
