/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 * @typedef {import('../types').IUserSplit} IUserSplit
 */

const {getUaasTestId} = require('./getUaasTestId');
const {getUaasUri} = require('./getUaasUri');
const {getUaasRequestHeaders} = require('./getUaasRequestHeaders');
const {getUserSplit} = require('./getUserSplit');

/**
 * Восстанавливает ссылку и хедеры для uaas из запроса
 *
 * @param {Request} req
 * @returns {Promise<IUserSplit>}
 */
function getUserSplitByRequest(req) {
    const testId = getUaasTestId(req.query, req.get('referrer'));
    const uri = getUaasUri(testId);
    const uaasRequestHeaders = getUaasRequestHeaders(req);

    return getUserSplit(uri, uaasRequestHeaders);
}

module.exports = {
    getUserSplitByRequest,
};
