/**
 * @typedef {import('@yandex-data-ui/core/lib/types').CoreConfig} CoreConfig
 * @typedef {import('@yandex-data-ui/core/lib/types').ICookies} ICookies
 * @typedef {import('../types').IUserSplit} IUserSplit
 */

/** @type {CoreConfig} */
const config = require('../../../../.config');
const {parseExperimentString} = require('./parseExperimentString');
const {mapExperimentsConfig} = require('./mapExperimentsConfig');
const {mergeUaasBackFlags} = require('./mergeUaasBackFlags');

/**
 *
 * @param {IUserSplit} userSplit
 * @param {ICookies} cookies
 * @returns {IUserSplit}
 */
function mergeUserSplitWithCookie(userSplit, cookies) {
    const {experiments, backFlags, rawExperiments, ...rest} = userSplit;

    const extendedBackFlags = mergeUaasBackFlags(backFlags, cookies.back_flags);

    const {uaasExperiments} = config;

    const experimentsFromCookies = mapExperimentsConfig(
        uaasExperiments,
        cookies,
    );

    const rawExperimentsFromCookies = Object.entries(
        experimentsFromCookies,
    ).reduce((acc, [experimentConfigKey, isEnabled]) => {
        if (!isEnabled) {
            return acc;
        }

        const configExperimentValue = uaasExperiments[experimentConfigKey];

        if (typeof configExperimentValue === 'string') {
            const {experimentKey, experimentValue} = parseExperimentString(
                configExperimentValue,
            );

            acc[experimentKey] = experimentValue;
        }

        return acc;
    }, {});

    return {
        ...rest,
        rawExperiments: {
            ...rawExperiments,
            ...rawExperimentsFromCookies,
        },
        experiments: {
            ...experiments,
            ...experimentsFromCookies,
        },
        backFlags: extendedBackFlags,
    };
}

module.exports = {
    mergeUserSplitWithCookie,
};
