/* eslint-disable camelcase */
import Geobase, {IGeolocation} from 'http-geobase';

import {QLOUD_HTTP_SERVICES_TIMEOUT} from '../../constants/common';

import {
    IGeobaseProvider,
    IGeolocationSearchData,
    THttpGeobaseRegion,
    THttpGeobaseTraits,
} from 'server/providers/geoBase/types';

const geobaseInstance = new Geobase('http://geobase-test.qloud.yandex.ru', {
    timeout: QLOUD_HTTP_SERVICES_TIMEOUT,
});

export default class HTTPGeobase implements IGeobaseProvider {
    async pinpointGeolocation(
        options: IGeolocationSearchData,
    ): Promise<IGeolocation> {
        // @ts-ignore
        // В описании типов http-geobase есть ошибка
        // Если передавать yandex_gid как строку, то это параметр не будет учитываться
        return geobaseInstance.pinpointGeolocation(options);
    }

    async regionById(id: number): Promise<THttpGeobaseRegion | undefined> {
        return geobaseInstance.regionById(id) as Promise<
            THttpGeobaseRegion | undefined
        >;
    }

    async regionsByType(type: number): Promise<THttpGeobaseRegion[]> {
        return geobaseInstance.regionsByType(type) as Promise<
            THttpGeobaseRegion[]
        >;
    }

    async findCountry(id: number): Promise<number> {
        return geobaseInstance.findCountry(id);
    }

    async traitsByIp(ip: string): Promise<THttpGeobaseTraits> {
        return geobaseInstance.traitsByIp(ip) as Promise<THttpGeobaseTraits>;
    }
}
