/* eslint-disable camelcase */
import Geobase, {geobase6} from '@yandex-int/yandex-geobase';

import {
    IGeobaseProvider,
    IGeolocationSearchData,
    TLocalGeobaseRegion,
    TLocalGeobaseTraits,
} from 'server/providers/geoBase/types';

export default class LocalGeobase implements IGeobaseProvider {
    private _geobase: geobase6.GeobaseLookup | undefined;

    get geobase(): geobase6.GeobaseLookup {
        if (!this._geobase) {
            this._geobase = Geobase.v6({
                geobaseData: '/var/cache/geobase/geodata6.bin',
            });
        }

        return this._geobase;
    }

    async pinpointGeolocation(
        options: IGeolocationSearchData,
    ): Promise<geobase6.IGeolocation> {
        const {yp_cookie = '', ys_cookie = '', ...localOptions} = options;

        return this.geobase.makePinpointGeolocation(
            localOptions,
            yp_cookie,
            ys_cookie,
        );
    }

    async regionById(id: number): Promise<TLocalGeobaseRegion | undefined> {
        return this.geobase.getRegionById(id) as
            | TLocalGeobaseRegion
            | undefined;
    }

    async regionsByType(type: number): Promise<TLocalGeobaseRegion[]> {
        return this.geobase.getRegionsByType(type) as TLocalGeobaseRegion[];
    }

    async findCountry(id: number): Promise<number> {
        return this.geobase.getCountryId(id);
    }

    async traitsByIp(ip: string): Promise<TLocalGeobaseTraits> {
        return this.geobase.getIpTraits(ip) as TLocalGeobaseTraits;
    }
}
