/* eslint-disable camelcase */
import {geobase6} from '@yandex-int/yandex-geobase';
import {ITraits, IRegion, IGeolocation} from 'http-geobase';

import {TGeoId} from 'types/TGeoId';

export interface IGeolocationSearchData {
    ip: string;
    x_forwarded_for?: string;
    x_real_ip?: string;
    yandex_gid?: number;
    yp_cookie: string;
    ys_cookie: string;
    is_trusted?: boolean;
    allow_yandex?: boolean;
}
type TTraitsWithGeoId<T> = T & {region_id: TGeoId};
export type TLocalGeobaseTraits = TTraitsWithGeoId<geobase6.ITraits>;
export type THttpGeobaseTraits = TTraitsWithGeoId<ITraits>;
export type TGeobaseTraits = TLocalGeobaseTraits | THttpGeobaseTraits;

type TRegionWithGeoId<T> = T & {id: TGeoId};
export type TLocalGeobaseRegion = TRegionWithGeoId<geobase6.IRegion>;
export type THttpGeobaseRegion = TRegionWithGeoId<IRegion>;
export type TGeobaseRegion = TLocalGeobaseRegion | THttpGeobaseRegion;
export type TGeobaseLocation = IGeolocation | geobase6.IGeolocation;

export interface IGeobaseProvider {
    /**
     * Определяет местоположение пользователя по совокупности информации о нем
     */
    pinpointGeolocation(
        options: IGeolocationSearchData,
    ): Promise<TGeobaseLocation | null>;
    /**
     * Получение информации о регионе с идентификатором id
     */
    regionById(id: number): Promise<TGeobaseRegion | undefined | null>;
    /**
     * Получение списка регионов с заданным типом
     */
    regionsByType(type: number): Promise<TGeobaseRegion[] | null>;
    /**
     * Выдает идентификатор страны, которой принадлежит регион
     */
    findCountry(id: number): Promise<number | null>;
    /**
     * Получает информацию о IP
     */
    traitsByIp(ip: string): Promise<TGeobaseTraits | null>;
}
