import {ServerDataFetcherBag} from 'server/redux/types';

import {setUnsubscribeStatus} from 'reducers/avia/search/subscription/actions';

import {AviaSubscriptionService} from 'server/services/AviaSubscriptionService';

export async function cancelAviaSubscription({
    req,
    dispatch,
}: ServerDataFetcherBag): Promise<void> {
    const aviaSubscriptionService =
        req.container.resolve<AviaSubscriptionService>(
            'aviaSubscriptionService',
        );

    let canceled = true;

    try {
        const {status} = await aviaSubscriptionService.unsubscribe({
            id: req.query.id,
        });

        canceled = status === 'success';
    } catch (e) {
        canceled = false;
    }

    dispatch(setUnsubscribeStatus(canceled));
}
