import {ServerDataFetcherBag} from 'server/redux/types';

import {decodeQueryKey} from 'projects/avia/lib/qid';
import {aviaURLs} from 'projects/avia/lib/urls';
import {resolveContainerValue} from 'server/utilities/container/resolve';

export async function confirmSubscription({
    req,
    res,
}: ServerDataFetcherBag): Promise<void> {
    const {
        query: {id, s, p, qkey},
    } = req;
    const aviaSubscriptionService = resolveContainerValue(
        req.container,
        'aviaSubscriptionService',
    );

    let confirmed = false;

    try {
        const data = await aviaSubscriptionService.confirmSubscription({
            id,
            s,
            p,
        });

        confirmed = data.confirmed;
    } catch (e) {}

    res.redirect(
        302,
        aviaURLs.getSearchResultsUrl({
            ...decodeQueryKey(qkey),
            emailConfirmed: confirmed,
        }),
    );
}
