import {Store} from 'redux';

import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {setAviaFeaturesFlags} from 'reducers/avia/featuresFlags/actions';

import setSearchDefaultSorting from './setSearchDefaultSorting';

export default (
    {req}: {req: Request; res: Response},
    reduxStore: Store,
): void => {
    const {dispatch} = reduxStore;

    if (req.aviaFeaturesFlags) {
        dispatch(setAviaFeaturesFlags(req.aviaFeaturesFlags));
    }

    setSearchDefaultSorting({req, reduxStore});
};
