import pathToRegExp from 'path-to-regexp';

import {URLs} from 'constants/urls';

import {IAviaFlightQuery} from 'types/avia/flight/IAviaFlightQuery';
import {ServerDataFetcherBag} from 'server/redux/types';

import requestFlightThunkAction from 'reducers/avia/flight/thunk/requestFlightThunkAction';

const FLIGHT_REGEXP = pathToRegExp(URLs.aviaFlight);

export default async function fetchFlight(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {
        req,
        req: {path},
        res,
        dispatch,
    } = serverFetcherData;

    const {when}: IAviaFlightQuery = req.query;

    const {1: flightIataAndNumber} = FLIGHT_REGEXP.exec(path) || [];

    const [iata, number] = flightIataAndNumber.split('-');

    await dispatch(
        requestFlightThunkAction({
            req,
            res,
            iata,
            number,
            departureDate: when,
        }),
    );
}
