import {ServerDataFetcherBag} from 'server/redux/types';

import {setUserGeoLocationAction} from 'reducers/common/userInfo/actions';

import {getUserGeoLocation} from 'selectors/common/userInfoSelector';

import requestGeoLookup from 'projects/avia/utilities/api/requestGeoLookup';
import {unknownToErrorOrUndefined} from 'utilities/error';

export async function fetchGeoPointWithAirport(
    fetcherBag: ServerDataFetcherBag,
): Promise<void> {
    try {
        const {req, getState, dispatch} = fetcherBag;
        const geoLocation = getUserGeoLocation(getState());
        const geoLookupResponse = await requestGeoLookup({
            geoId: geoLocation.geoId,
            req,
        });

        // Заменяем геопозицию на ближайший город с аэропортом если требуется
        if (
            geoLookupResponse &&
            geoLookupResponse.searchCity.geoId !== geoLocation.geoId
        ) {
            dispatch(
                setUserGeoLocationAction({
                    geoName: geoLookupResponse.searchCity.title,
                    geoId: geoLookupResponse.searchCity.geoId,
                    countryId: geoLookupResponse.searchCity.country.id,
                }),
            );
        }
    } catch (e) {
        fetcherBag.req.utils.logWarn(
            'fetchGeoPointWithAirport: Could not get geolocation',
            unknownToErrorOrUndefined(e),
        );
    }
}
