import {ServerDataFetcherBag} from 'server/redux/types';

import {
    fillSearchFormByContext,
    prefillAviaContext,
} from 'server/redux/avia/prefillSearchForm';

export default async function prefetchInvalidSearchData(
    fetcherBag: ServerDataFetcherBag,
): Promise<void> {
    await prefillAviaContext(fetcherBag, fetcherBag.req.query, false);
    fillSearchFormByContext(fetcherBag);
}
