import {USER_SETTLEMENT} from 'projects/avia/constants/constants';

import {ServerDataFetcherBag} from 'server/redux/types';

import handleSearchWithParams from 'server/redux/avia/pages/search/handleSearchWithParams';
import getSearchParamsFromQuery from 'server/redux/avia/pages/search/getSearchParamsFromQuery';
import handleSearchWithPlaceholders from 'server/redux/avia/pages/search/handleSearchWithPlaceholders';

export default async function prefetchSearchData(
    fetcherBag: ServerDataFetcherBag,
): Promise<void> {
    const {fromId, toId} = getSearchParamsFromQuery(fetcherBag.req.query);
    const searchHandler =
        fromId === USER_SETTLEMENT || toId === USER_SETTLEMENT
            ? handleSearchWithPlaceholders
            : handleSearchWithParams;

    await searchHandler(fetcherBag);
}
