import {pick} from 'lodash';

import {AVIA_PARAMS_KEYS} from 'projects/avia/constants/queryParams';

import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

import {processAviaSearchParams} from 'projects/avia/lib/search/processAviaSearchParams';

export default function getSearchParamsFromQuery(
    query: unknown,
): Partial<IAviaParams> {
    return processAviaSearchParams(pick(query, AVIA_PARAMS_KEYS));
}
