import {ServerDataFetcherBag} from 'server/redux/types';

import {aviaURLs} from 'projects/avia/lib/urls';

import replaceSearchParamPlaceholders from 'server/redux/avia/replaceSearchParamPlaceholders';

export default async function handleSearchWithPlaceholders(
    fetcherBag: ServerDataFetcherBag,
): Promise<void> {
    const {req, res} = fetcherBag;

    try {
        const {fromId, toId} = await replaceSearchParamPlaceholders(
            fetcherBag,
            req.query.fromId,
            req.query.toId,
        );

        const searchQuery = {
            ...req.query,
            fromId,
            toId,
        };

        // Этот меджик нужен, чтобы при редиректе сохранить фильтры (они хранятся в хэше)
        res.send(`<!DOCTYPE html><meta charset="utf-8"><html><body>
        <script type="text/javascript" nonce="${req.nonce}">
            var hash = (location.href.split("#")[1] || null);
            var pathField = "${aviaURLs.getSearchResultsUrl(searchQuery)}";

            if (hash) {
                if (pathField.indexOf("#") === -1) {
                    pathField = pathField + "#" + hash;
                }
            }

            window.location = pathField;
        </script></body></html>`);
    } catch (e) {
        res.redirect(302, aviaURLs.getAviaRoot(req.query));
    }
}
