import {ServerDataFetcherBag} from 'server/redux/types';
import {IAviaDataByPointKey} from 'server/services/AviaGeoService/types/IAviaDataByPointKey';

import {setAviaPointsData} from 'reducers/avia/pointsData/actions';

import {resolveContainerValue} from 'server/utilities/container/resolve';

interface IFillPointDataParams {
    fromId?: string;
    toId?: string;
}

export async function prefillAviaPointsData(
    {dispatch, req}: ServerDataFetcherBag,
    params: IFillPointDataParams | null = null,
): Promise<void> {
    const aviaGeoService = resolveContainerValue(
        req.container,
        'aviaGeoService',
    );

    try {
        const {fromId, toId} = params || req.query;

        const [from, to] = await Promise.all<IAviaDataByPointKey | null>([
            fromId ? aviaGeoService.getDataByPointKey(fromId) : null,
            toId ? aviaGeoService.getDataByPointKey(toId) : null,
        ]);

        dispatch(
            setAviaPointsData({
                from,
                to,
            }),
        );
    } catch (e) {}
}
