import {ServerDataFetcherBag} from 'server/redux/types';

import {IAviaContext} from 'reducers/avia/data-types';
import {getCountryRestrictionsActions} from 'reducers/avia/countryRestrictions/actions';

import {getAviaContext} from 'selectors/avia/aviaSelectors';

import {needShowCountryRestrictions} from 'projects/avia/utilities/needShowCountryRestrictions';
import {isStationKey} from 'utilities/strings/isStationKey';
import {isSettlementKey} from 'utilities/strings/isSettlementKey';

import {aviaProvider} from 'serviceProvider/avia/aviaProvider';

export async function prefillCountryRestrictions({
    dispatch,
    req,
    getState,
}: ServerDataFetcherBag): Promise<void> {
    dispatch(getCountryRestrictionsActions.reset());

    const aviaContext: IAviaContext = getAviaContext(getState());

    if (!aviaContext.from || !aviaContext.to) {
        return;
    }

    const {
        from: {countryTitle: fromCountryTitle, pointKey: fromPointKey},
        to: {countryTitle: toCountryTitle, pointKey: toPointKey},
    } = aviaContext;

    if (
        !needShowCountryRestrictions(fromCountryTitle, toCountryTitle) ||
        !(isStationKey(fromPointKey) || isSettlementKey(fromPointKey)) ||
        !(isStationKey(toPointKey) || isSettlementKey(toPointKey))
    ) {
        return;
    }

    try {
        dispatch(getCountryRestrictionsActions.request());

        const countryRestrictionsResponse = await aviaProvider
            .provider(req?.container)
            .getExtendedCountryRestrictions({
                fromPointKey,
                toPointKey,
            });

        dispatch(
            getCountryRestrictionsActions.success(countryRestrictionsResponse),
        );
    } catch (e) {
        dispatch(getCountryRestrictionsActions.failure(e));
    }
}
