import {ServerDataFetcherBag} from 'server/redux/types';

import {
    prefillAviaContext,
    prefillAviaSearchForm,
} from 'server/redux/avia/prefillSearchForm';

export default async function prefillFlightSearchFormAndContext(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {getState} = serverFetcherData;

    const {
        avia: {
            flight: {value: flight},
        },
    } = getState();

    if (!flight) {
        return;
    }

    const {searchForm} = flight.blocks;

    const params = {
        fromId: searchForm.fromId,
        toId: searchForm.toId,
        when: searchForm.departureDate,
    };

    await Promise.all([
        prefillAviaSearchForm(serverFetcherData, params),
        prefillAviaContext(serverFetcherData, params),
    ]);
}
