import {USER_SETTLEMENT} from 'projects/avia/constants/constants';

import {ServerDataFetcherBag} from 'server/redux/types';
import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import {TUserSettlement} from 'types/avia/TUserSettlement';

import {getUserGeoLocation} from 'selectors/common/userInfoSelector';

import requestGeoLookup from 'projects/avia/utilities/api/requestGeoLookup';
import {getSettlementKeyById} from 'utilities/strings/getSettlementKeyById';
import {resolveContainerValue} from 'server/utilities/container/resolve';

// Зменяет '-me' в пунктах откуда/куда на текущий город пользователя
export default async function replaceSearchParamPlaceholders(
    fetcherBag: ServerDataFetcherBag,
    fromId: IAviaParams['fromId'] | TUserSettlement,
    toId: IAviaParams['toId'] | TUserSettlement,
): Promise<{
    fromId: IAviaParams['fromId'];
    toId: IAviaParams['toId'];
}> {
    const {req, getState} = fetcherBag;
    const {geoId: geoIdCommon} = getUserGeoLocation(getState());

    if (!geoIdCommon) {
        throw new Error();
    }

    const geoLookupResponse = await requestGeoLookup({
        geoId: geoIdCommon,
        req,
    });

    if (!geoLookupResponse) {
        throw new Error();
    }

    const {
        searchCity: {geoId},
    } = geoLookupResponse;

    const aviaGeoService = resolveContainerValue(
        req.container,
        'aviaGeoService',
    );

    const data = await aviaGeoService.getDataByGeoId(geoId);

    if (!data?.settlement?.id) {
        throw new Error(`Не удалось найти город с geoId '${geoId}'`);
    }

    const userSettlementId = getSettlementKeyById(data.settlement.id);

    return {
        fromId: fromId === USER_SETTLEMENT ? userSettlementId : fromId,
        toId: toId === USER_SETTLEMENT ? userSettlementId : toId,
    };
}
