import {ServerDataFetcherBag} from '../types';

import {setResultsSorting} from 'reducers/avia/search/results/actions';

import {getSortingFromCookies} from 'projects/avia/lib/search/aviaSortingCookie';

// NOTE: Server Fetch Data Dispatcher requires function to return a promise
export async function setAviaSort({
    req,
    dispatch,
}: ServerDataFetcherBag): Promise<void> {
    const sorting = getSortingFromCookies(req.cookies);

    if (sorting) {
        dispatch(setResultsSorting(sorting));
    }
}
