import {Store} from 'redux';

import {Request} from '@yandex-data-ui/core/lib/types';

import {setResultsSorting} from 'reducers/avia/search/results/actions';
import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import {ESortDirection} from 'projects/avia/lib/comparators/TComparator';
import {getSortingFromCookies} from 'projects/avia/lib/search/aviaSortingCookie';

export default ({req, reduxStore}: {req: Request; reduxStore: Store}): void => {
    const {dispatch} = reduxStore;
    const {aviaDefaultSortPrice} = req.experiments;
    const sorting = getSortingFromCookies(req.cookies);

    /*
     * при выпиливании экспа aviaDefaultSortPrice это нужно убрать
     * и в сторе установить нужную дефолтную сортировку
     */
    if (aviaDefaultSortPrice && !sorting) {
        dispatch(
            setResultsSorting({
                type: EAviaResultsSortType.PRICE,
                direction: ESortDirection.ASCENDING,
            }),
        );
    }
};
