import pathToRegExp from 'path-to-regexp';

import {URLs} from 'constants/urls';

import {ServerDataFetcherBag} from 'server/redux/types';
import {IBusesSearchQuery} from 'types/buses/search/IBusesSearchQuery';

import requestContextAction from 'reducers/buses/context/thunk/requestContextAction';

const SEARCH_REGEXP = pathToRegExp(URLs.busesSearch);

export default async function fetchContextFromPath(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {
        req,
        req: {path, query},
        dispatch,
    } = serverFetcherData;

    const {1: fromSlug = '', 3: toSlug = ''} = SEARCH_REGEXP.exec(path) || [];
    const {date: when}: IBusesSearchQuery = query;

    await dispatch(
        requestContextAction({
            req,
            params: {
                fromSlug,
                toSlug,
                when,
            },
        }),
    );
}
