import {ServerDataFetcherBag} from 'server/redux/types';
import {IBusesIndexQuery} from 'types/buses/index/IBusesIndexQuery';
import {isFilledContext} from 'types/buses/common/IBusesContext';

import {getContextActions} from 'reducers/buses/context/actions';

import requestContext from 'projects/buses/utilities/api/requestContext';

export default async function fetchContextFromQuerySlugs({
    req,
    dispatch,
}: ServerDataFetcherBag): Promise<void> {
    const {query} = req;

    const {fromSlug, toSlug}: IBusesIndexQuery = query;

    if (!fromSlug || !toSlug) {
        return;
    }

    try {
        const apiContext = await requestContext({
            req,
            params: {
                fromSlug,
                toSlug,
            },
        });

        const context = {
            ...apiContext,
            when: null,
            originWhen: null,
        };

        if (!isFilledContext(context)) {
            dispatch(getContextActions.failure());

            return;
        }

        dispatch(getContextActions.success(context));
    } catch (err) {
        dispatch(getContextActions.failure());
    }
}
