import {ServerDataFetcherBag} from 'server/redux/types';

import fillSearchFormThunkAction from 'reducers/buses/search/thunk/fillSearchFormThunkAction';

export default async function fillSearchFormBySearchContext({
    getState,
    dispatch,
}: ServerDataFetcherBag): Promise<void> {
    const {
        buses: {
            context: {value: context},
        },
    } = getState();

    if (!context) {
        return;
    }

    dispatch(fillSearchFormThunkAction(context));
}
