import {ServerDataFetcherBag} from 'server/redux/types';
import {IBusesIndexQuery} from 'types/buses/index/IBusesIndexQuery';
import {ESearchFormFieldName} from 'components/SearchForm/types';

import requestSearchSuggestsThunkAction from 'reducers/buses/searchSuggests/thunk/requestSearchSuggestsThunkAction';

import fetchContextFromQuerySlugs from 'server/redux/buses/fetchContextFromQuerySlugs';
import fillSearchFormBySearchContext from 'server/redux/buses/fillSearchFormBySearchContext';

export default async function prefillSearchForm(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {req, dispatch, getState} = serverFetcherData;

    const {query} = req;

    const {fromSlug, toSlug}: IBusesIndexQuery = query;

    if (!fromSlug || !toSlug) {
        const {
            buses: {searchForm},
        } = getState();

        await dispatch(
            requestSearchSuggestsThunkAction({
                fromField: searchForm[ESearchFormFieldName.FROM],
                toField: searchForm[ESearchFormFieldName.TO],
                needToSetByGeoPointIfPossible: true,
                req,
            }),
        );

        return;
    }

    await fetchContextFromQuerySlugs(serverFetcherData);
    await fillSearchFormBySearchContext(serverFetcherData);
}
