import {ServerDataFetcherBag} from 'server/redux/types';
import {IBusesSearchQuery} from 'types/buses/search/IBusesSearchQuery';
import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';

import {updateFiltersAction} from 'reducers/buses/search/filters/actions';

import getFormattedFilterValue from 'projects/buses/utilities/search/getFormattedFilterValue';

export default async function setFilters(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {
        req: {query},
        dispatch,
    } = serverFetcherData;

    const {
        price = [],
        departureTime = [],
        arrivalTime = [],
        departureStation = [],
        arrivalStation = [],
    }: IBusesSearchQuery = query;

    dispatch(
        updateFiltersAction({
            [EBusesFilter.PRICE]: price.length
                ? [Number(price[0]), Number(price[1])]
                : null,
            [EBusesFilter.DEPARTURE_TIME]:
                getFormattedFilterValue(departureTime),
            [EBusesFilter.ARRIVAL_TIME]: getFormattedFilterValue(arrivalTime),
            [EBusesFilter.DEPARTURE_STATION]:
                getFormattedFilterValue(departureStation),
            [EBusesFilter.ARRIVAL_STATION]:
                getFormattedFilterValue(arrivalStation),
        }),
    );
}
