import {ServerDataFetcherBag} from 'server/redux/types';
import {IBusesSearchQuery} from 'types/buses/search/IBusesSearchQuery';

import {setSortAction} from 'reducers/buses/search/sort/actions';

export default async function setSorts(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {
        req: {query},
        dispatch,
    } = serverFetcherData;

    const {sortBy, sortDirection}: IBusesSearchQuery = query;

    if (sortBy && sortDirection) {
        dispatch(
            setSortAction({
                type: sortBy,
                direction: sortDirection,
            }),
        );
    }
}
