import {fetchTravelApp, fetchPlatform} from 'reducers/avia/platform/actions';

import setIsBot from 'server/redux/common/setIsBot';
import fetchDeviceType from 'server/redux/common/fetchDeviceType';
import fetchUserInfo from 'server/redux/common/fetchUserInfo';
import fetchFeatures from 'server/redux/common/fetchFeatures';
import fetchExperiments from 'server/redux/common/fetchExperiments';
import fetchUserSplit from 'server/redux/common/fetchUserSplit';
import fetchCSRFToken from 'server/redux/common/fetchCSRFToken';
import fetchViewState from 'server/redux/common/fetchViewState';
import setUserUnreadMailCount from 'server/redux/common/setUserUnreadMailCount';
import setNonce from 'server/redux/common/setNonce';
import setAdFoxParams from 'server/redux/common/setAdFoxParams';
import fetchTogglers from 'server/redux/common/fetchTogglers';
import fetchPageInfo from 'server/redux/common/fetchPageInfo';
import fetchCitizenship from 'server/redux/common/fetchCitizenship';
import fetchAppVersion from 'server/redux/common/fetchAppVersion';
import setIsFromXredirect from 'server/redux/common/setIsFromXredirect';

export default ({req, res}, reduxStore) => {
    const {dispatch} = reduxStore;

    dispatch(fetchDeviceType(req));
    dispatch(fetchUserInfo(req));
    dispatch(fetchFeatures(req));
    dispatch(fetchCSRFToken(res));
    dispatch(fetchExperiments(req));
    dispatch(fetchUserSplit(req));
    dispatch(fetchViewState(req));
    dispatch(setUserUnreadMailCount(req));
    dispatch(setNonce(req));
    dispatch(setAdFoxParams(req));
    dispatch(fetchPlatform(req));
    dispatch(fetchTravelApp(req));
    dispatch(fetchTogglers(req, res));
    dispatch(setIsBot(req));
    dispatch(fetchPageInfo(req));
    dispatch(fetchCitizenship(req));
    dispatch(fetchAppVersion(req));
    dispatch(setIsFromXredirect(req));
};
