import {ServerDataFetcherBag} from 'server/redux/types';

import {currenciesFetchActions} from 'reducers/common/currencies/actions';

import {resolveContainerValue} from 'server/utilities/container/resolve';

import {geobaseService} from 'serviceProvider';

export async function fetchCurrencies({
    req,
    dispatch,
}: ServerDataFetcherBag): Promise<void> {
    const currenciesService = resolveContainerValue(
        req.container,
        'currenciesService',
    );

    try {
        const {geoId} = await geobaseService
            .provider(req?.container)
            .getUserGeoLocation();

        const currenciesInfo = await currenciesService.getCurrencyInfo(geoId);

        dispatch(currenciesFetchActions.success(currenciesInfo));
    } catch (e) {
        dispatch(currenciesFetchActions.failure());
    }
}
