import {Store} from 'redux';

import {Request} from '@yandex-data-ui/core/lib/types';

import {setEnvironmentConfigAction} from 'reducers/common/environmentConfig/actions';

export default (req: Request, reduxStore: Store): void => {
    const {tld} = req;
    const {dispatch} = reduxStore;
    const {environmentConfig, csrf} = req.utils.config;
    const {secureIFramePath, uxfeedbackIframeSrc} = environmentConfig || {};

    dispatch(
        setEnvironmentConfigAction({
            secureIFramePath,
            uxfeedbackIframeSrc,
            tld,
            // csrf.lifetime задаётся в секундах
            csrfTokenValidTill: csrf?.lifetime
                ? Date.now() + csrf.lifetime * 1000
                : null,
        }),
    );
};
