import {Request} from '@yandex-data-ui/core/lib/types';

import {setEntryPage} from 'reducers/common/page/actions';
import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {getRequestFullUrl} from 'server/utilities/request/getRequestFullUrl';

export default function fetchPageInfo(req: Request): CustomThunkAction<void> {
    return (dispatch): void => {
        dispatch(setEntryPage(getRequestFullUrl(req)));
    };
}
