import {ServerDataFetcherBag} from 'server/redux/types';

import {unknownToErrorOrUndefined} from 'utilities/error';

interface IServerDataFetcher {
    (bag: ServerDataFetcherBag): Promise<unknown>;
}

export default async function fetchProjectReduxInfo(
    bag: ServerDataFetcherBag,
    fetchDataList: IServerDataFetcher[],
): Promise<void> {
    try {
        await Promise.all(
            fetchDataList.map(fetchServerData => fetchServerData(bag)),
        );
    } catch (e) {
        bag.req.utils.logWarn(
            'FAILED_FETCH_PROJECT_REDUX_INFO',
            unknownToErrorOrUndefined(e),
        );
    }
}
