import {ServerDataFetcherBag} from 'server/redux/types';

import {setUserGeoLocationAction} from 'reducers/common/userInfo/actions';

import {unknownToErrorOrUndefined} from 'utilities/error';

import {geobaseService} from 'serviceProvider';

export default async function fetchUserGeoLocation({
    dispatch,
    req,
}: ServerDataFetcherBag): Promise<void> {
    try {
        const queryLr = req.query.lr;
        const lr = typeof queryLr === 'string' ? queryLr : undefined;
        const userGeoLocation = await geobaseService
            .provider(req?.container)
            .getUserGeoLocation(lr);

        dispatch(setUserGeoLocationAction(userGeoLocation));
    } catch (e) {
        req.utils.logWarn(
            'FAILED_FETCH_USER_GEOLOCATION',
            unknownToErrorOrUndefined(e),
        );
    }
}
