import {Action} from 'typesafe-actions';

import {Request} from '@yandex-data-ui/core/lib/types';

import {setUserInfoAction} from 'reducers/common/userInfo/actions';

export interface IFetchUserPassportConfig {
    avatarPath: string;
    passportPath: string;
    authorizePath: string;
}

const getPassportConfig = (req: Request): IFetchUserPassportConfig => {
    const {avatarPath, passportPath, authorizePath} = req.utils.config.passport;

    return {
        avatarPath,
        passportPath,
        authorizePath,
    };
};

const getUserCookies = (req: Request): string => req.cookies.yandexuid || '';

export default function fetchUserInfo(req: Request): Action {
    const passportConfig = getPassportConfig(req);
    const yu = getUserCookies(req);
    const {userInfo} = req;

    return setUserInfoAction({passportConfig, yu, userInfo});
}
