import {ServerDataFetcherBag} from 'server/redux/types';
import {IWhiteLabelService} from 'server/services/WhiteLabelService/types/IWhiteLabelService';

import {setWhiteLabelConfigAction} from 'reducers/common/whiteLabelConfig/actions';

import {unknownToErrorOrUndefined} from 'utilities/error';

export default async function fetchWhiteLabelConfig({
    req,
    dispatch,
}: ServerDataFetcherBag): Promise<void> {
    const {partner, container} = req;

    if (partner === null) {
        return undefined;
    }

    const whiteLabelService =
        container.resolve<IWhiteLabelService>('whiteLabelService');

    try {
        const config = await whiteLabelService.getConfigByName(partner);

        dispatch(setWhiteLabelConfigAction(config));
    } catch (error) {
        req.utils.logWarn(
            `FAILED_FETCH_WHITE_LABEL_CONFIG: There is no configuration for partner ${partner}`,
            unknownToErrorOrUndefined(error),
        );
    }
}
