import pathToRegExp from 'path-to-regexp';

import {URLs} from 'constants/urls';

import {ServerDataFetcherBag} from 'server/redux/types';
import {isFirmTrain} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';

import requestFirmTrainThunkAction from 'reducers/trains/firmTrain/thunk/requestFirmTrainThunkAction';

const FIRM_TRAIN_PATH_REGEXP = pathToRegExp(URLs.trainsFirmTrain);

export default async function fetchFirmTrain(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {
        req,
        req: {path},
        dispatch,
    } = serverFetcherData;

    const {1: slug} = FIRM_TRAIN_PATH_REGEXP.exec(path) || [];

    if (!isFirmTrain(slug)) {
        return;
    }

    await dispatch(
        requestFirmTrainThunkAction({
            req,
            params: {
                slug,
            },
        }),
    );
}
