import pathToRegExp from 'path-to-regexp';

import {URLs} from 'constants/urls';

import {ServerDataFetcherBag} from 'server/redux/types';

import requestDirectionSearchPageAction from 'reducers/trains/direction/thunk/requestDirectionSearchPageAction';

const SEARCH_DIRECTION_PATH_REGEXP = pathToRegExp(URLs.trainsSearch);

export default async function requestDirectionSearchPageSSR(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    const {
        req,
        req: {path},
        dispatch,
    } = serverFetcherData;

    const {1: fromSlug = '', 3: toSlug = ''} =
        SEARCH_DIRECTION_PATH_REGEXP.exec(path) || [];

    if (!fromSlug || !toSlug) {
        return;
    }

    await dispatch(
        requestDirectionSearchPageAction({
            req,
            params: {
                fromSlug,
                toSlug,
            },
        }),
    );
}
