import pathToRegExp from 'path-to-regexp';

import {OutdatedSearchError} from 'projects/trains/lib/search/constants';
import {URLs} from 'constants/urls';
import {ERedirectStatusCodes} from 'constants/redirectStatusCodes';

import {ServerDataFetcherBag} from 'server/redux/types';

import {preFetchDataForGenericSearchServer} from 'reducers/trains/genericSearch/search/thunkActions';

import getContextFromSearchUrlParams from 'projects/trains/lib/context/getContextFromSearchUrlParams';
import {trainsURLs} from 'projects/trains/lib/urls';

const SEARCH_REGEXP = pathToRegExp(URLs.trainsSearch);

export async function trainsPreFetchDataForGenericSearchSSR({
    req,
    res,
    dispatch,
    getState,
}: ServerDataFetcherBag): Promise<void> {
    const {when, returnWhen, direction, forwardSegmentId, backwardSegmentId} =
        req.query;
    const {1: fromSlug = '', 3: toSlug = ''} =
        SEARCH_REGEXP.exec(req.path) || [];
    const context = getContextFromSearchUrlParams({
        fromSlug,
        toSlug,
        when,
        returnWhen,
        direction,
        forwardSegmentId,
        backwardSegmentId,
    });

    try {
        await dispatch(
            preFetchDataForGenericSearchServer({
                req,
                context,
            }),
        );
    } catch (e) {
        if (e instanceof OutdatedSearchError) {
            const {
                trains: {
                    context: {from, to},
                },
            } = getState();

            res.redirect(
                ERedirectStatusCodes.TEMPORARILY,
                trainsURLs.getTrainsSearchUrl({
                    context: {
                        from: from?.slug ?? '',
                        to: to?.slug ?? '',
                    },
                    query: {
                        m__outdate_search_request: 1,
                    },
                }),
            );
        }
    }
}
