import omit from 'lodash/omit';
import pathToRegExp from 'path-to-regexp';

import {URLs} from 'constants/urls';

import {ServerDataFetcherBag} from 'server/redux/types';

import {trainsURLs} from 'projects/trains/lib/urls';

const SEARCH_REGEXP_WITH_WHEN_PARAM = pathToRegExp(
    URLs.trainsOldSearchWithWhenParam,
);

/*
 * Редиректим запросы с when в параметрах /trains/yekaterinburg--moscow/2018-10-16
 * на поиск с when в query /yekaterinburg--moscow/?when=2018-10-16
 */
export default async function trainsRedirectOldSearchWithWhenParam({
    req,
    res,
}: ServerDataFetcherBag): Promise<void> {
    /*
     *  params не может быть null, т.к. функция вызывается в компоненте
     *  TrainsRedirectOldSearchWithWhenParam с роутингом URLs.trainsOldSearchWithWhenParam.
     */
    const params = SEARCH_REGEXP_WITH_WHEN_PARAM.exec(
        req.path,
    ) as RegExpExecArray;

    const {1: fromSlug, 3: toSlug, 4: when} = params;

    const urlToRedirect = trainsURLs.getTrainsSearchUrl({
        context: {
            from: fromSlug,
            to: toSlug,
            when: when,
        },
        query: omit(req.query, ['when']),
    });

    res.redirect(301, urlToRedirect);
}
