import {ServerDataFetcherBag} from 'server/redux/types';
import {ESearchFormFieldName} from 'components/SearchForm/types';

import trainsParseContext, {
    ITrainsParseContextParams,
} from 'reducers/trains/context/actions/trainsParseContext';
import {fillFormFromContextThunkAction} from 'reducers/trains/searchForm/thunk/fillFormFromContextThunkAction';
import requestSearchSuggestsThunkAction from 'reducers/trains/searchSuggests/thunk/requestSearchSuggestsThunkAction';

import isTrainsOutdatedOrWrongWhen from 'projects/trains/lib/date/isTrainsOutdatedOrWrongWhen';
import {trainsURLs} from 'projects/trains/lib/urls';

/**
 * Функция предзаполняет поисковую форму жд при SSR.
 */
export default async function trainsServerPreFillSearchForm({
    req,
    res,
    dispatch,
    getState,
}: ServerDataFetcherBag): Promise<void> {
    const {
        query: {fromSlug, toSlug, when, returnWhen},
    } = req;

    if (!fromSlug && !toSlug && !when) {
        const {
            trains: {searchForm},
        } = getState();

        await dispatch(
            requestSearchSuggestsThunkAction({
                fromField: searchForm[ESearchFormFieldName.FROM],
                toField: searchForm[ESearchFormFieldName.TO],
                needToSetByGeoPointIfPossible: true,
                req,
            }),
        );

        return;
    }

    if (when && isTrainsOutdatedOrWrongWhen(when)) {
        res.redirect(
            302,
            trainsURLs.getTrainsSearchUrl({
                context: {
                    from: fromSlug,
                    to: toSlug,
                },
                query: {
                    m__outdate_index_request: 1,
                },
            }),
        );

        return;
    }

    const context: ITrainsParseContextParams = {
        from: {},
        to: {},
        returnWhen,
        originalWhen: when,
    };

    if (fromSlug) {
        context.from = {
            slug: fromSlug,
        };
    }

    if (toSlug) {
        context.to = {
            slug: toSlug,
        };
    }

    try {
        await dispatch(trainsParseContext(context, req.container));
    } catch (err) {}

    dispatch(fillFormFromContextThunkAction());
}
