import {FunctionComponent, useMemo} from 'react';
import ReactHelmet from 'react-helmet';

import {
    ampBoilerplateStyleString,
    ampBoilerplateNoScriptStyleString,
} from './constants/ampBoilerplateStyle';

import favicons from 'components/BaseTravelHelmet/images/favicons';

interface IHtmlContainerProps {
    appString: string;
    styleString: string;
}

const HtmlContainer: FunctionComponent<IHtmlContainerProps> = ({
    appString,
    styleString,
}) => {
    const helmet = useMemo(() => {
        const helmetInstance = ReactHelmet.renderStatic();

        return (
            <head>
                <meta charSet="utf-8" />
                <link
                    rel="shortcut icon"
                    type="image/x-icon"
                    href={favicons.common}
                />
                <link
                    rel="shortcut icon"
                    type="image/x-icon"
                    sizes="16x16"
                    href={favicons[16]}
                />
                <link
                    rel="shortcut icon"
                    type="image/x-icon"
                    sizes="32x32"
                    href={favicons[32]}
                />
                <meta
                    name="viewport"
                    content="width=device-width, minimum-scale=1, initial-scale=1"
                />
                <style
                    amp-custom=""
                    dangerouslySetInnerHTML={{
                        __html: styleString,
                    }}
                />
                {helmetInstance.base.toComponent()}
                {helmetInstance.title.toComponent()}
                {helmetInstance.meta.toComponent()}
                {helmetInstance.link.toComponent()}
                {helmetInstance.script.toComponent()}

                <script async src="https://cdn.ampproject.org/v0.js"></script>

                <style amp-boilerplate="">{ampBoilerplateStyleString}</style>

                <noscript>
                    <style amp-boilerplate="">
                        {ampBoilerplateNoScriptStyleString}
                    </style>
                </noscript>
            </head>
        );
    }, [styleString]);

    return (
        // @ts-ignore
        <html amp="">
            {helmet}
            <body>
                <div id="app" dangerouslySetInnerHTML={{__html: appString}} />
            </body>
        </html>
    );
};

export default HtmlContainer;
