import {StrictMode, FunctionComponent} from 'react';
import {StaticRouter} from 'react-router-dom';
import {StaticRouterContext} from 'react-router';

import {Request} from '@yandex-data-ui/core/lib/types';

import AppAmp from 'containers/AppAmp/AppAmp';

interface IServerAmpAppProps {
    req: Request;
    routerContext: StaticRouterContext;
}

const ServerAmpApp: FunctionComponent<IServerAmpAppProps> = ({
    req,
    routerContext,
}) => {
    return (
        <StrictMode>
            <StaticRouter location={req.url} context={routerContext}>
                <AppAmp />
            </StaticRouter>
        </StrictMode>
    );
};

export default ServerAmpApp;
