/* eslint-disable no-unused-vars */
import {renderToStaticMarkup} from 'react-dom/server';

import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import locales from 'utilities/dateUtils/locales';
import {setDateLocale} from 'utilities/dateUtils';
import getCriticalCss from 'server/utilities/getCriticalCss';
import addDoctypeString from 'server/utilities/html/addDoctypeString';
import {getChunkExtractor} from 'server/utilities/loadable/getChunkExtractor';
import {responseByRouterContext} from './utilities/renderServer/responseByRouterContext';

import ServerAmpApp from './render/components/ServerAmpApp/ServerAmpApp';
import HtmlAmpContainer from './render/components/HtmlAmpContainer/HtmlAmpContainer';

setDateLocale(locales.RU);

/* Main render */
export default () => async (req, res) => {
    if (!req.experiments.ampPagesEnabled) {
        return res.redirect(301, URLs[EProjectName.NOT_FOUND]);
    }

    try {
        const routerContext = {};
        const extractor = getChunkExtractor(['clientAmp']);
        const jsx = extractor.collectChunks(
            <ServerAmpApp req={req} routerContext={routerContext} />,
        );
        const appString = renderToStaticMarkup(jsx);
        const styleString = getCriticalCss(extractor);

        // Убираем charset т.к. для inline стилей они не нужны. А AMP ругается на эту строку
        const patchedStyleString = styleString.replace(
            /@charset "UTF-8";/g,
            '',
        );

        const html = addDoctypeString(
            renderToStaticMarkup(
                <HtmlAmpContainer
                    appString={appString}
                    styleString={patchedStyleString}
                />,
            ),
        );

        return responseByRouterContext(res, routerContext, html);
    } catch (error) {
        req.utils.logError('AMP RENDER ERROR', error);
    }
};
