import {IOrderDTO} from 'server/api/AviaBookingApi/types/IOrderDTO';
import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';
import {IBookingCreateOrderRequest} from 'projects/avia/pages/AviaBooking/types/IBookingCreateOrder';
import IAviaGetOrderApiParams from 'server/api/AviaBookingApi/types/IAviaGetOrderApiParams';

import {apiVariantsToVariantsBookingModel} from 'server/services/AviaBookingService/variants/processApiVariants';
import {
    AviaBookingVariantsApi,
    AviaBookingOrdersApi,
} from 'server/api/AviaBookingApi/AviaBookingApi';
import {IDependencies} from 'server/getContainerConfig';
import {orderDtoToPageModel} from 'server/services/AviaBookingService/order/orderDTOtoPageModel';
import {IAviaBookingOrderPageData} from 'server/services/AviaBookingService/order/IAviaBookingOrderPageData';
import {TestContextService} from 'server/services/TestContextService/TestContextService';

export class AviaBookingService {
    private aviaBookingApi: AviaBookingVariantsApi;

    private aviaBookingOrdersApi: AviaBookingOrdersApi;

    private testContextService: TestContextService;

    constructor({
        aviaBookingVariantsApi,
        aviaBookingOrdersApi,
        testContextService,
    }: IDependencies) {
        this.aviaBookingApi = aviaBookingVariantsApi;
        this.aviaBookingOrdersApi = aviaBookingOrdersApi;
        this.testContextService = testContextService;
    }

    async createOrder(order: IBookingCreateOrderRequest): Promise<IOrderDTO> {
        const paymentTestContextToken =
            await this.testContextService.getPaymentTestContextTokenIfNeeded(
                order.paymentTestContextToken,
            );

        return this.aviaBookingOrdersApi.createOrder({
            ...order,
            paymentTestContextToken,
        });
    }

    async getVariants(
        variantToken: string,
    ): Promise<IBookingVariantsModelType> {
        const variant = await this.aviaBookingApi.variants(variantToken);

        return apiVariantsToVariantsBookingModel(variant);
    }

    async getOrder(
        params: IAviaGetOrderApiParams,
    ): Promise<IAviaBookingOrderPageData> {
        return this.aviaBookingOrdersApi
            .getOrder(params)
            .then(orderDtoToPageModel);
    }
}
