import {OrderStateType} from 'server/api/AviaBookingApi/types/OrderStateType';
import {ITravellerInfoDTO} from 'server/api/AviaBookingApi/types/ITravellerInfoDTO';
import {IBookingSegmentModel} from 'server/services/AviaBookingService/variants/types';
import EDisplayOrderState from 'types/common/orders/EDisplayOrderState';

import IPrice from 'utilities/currency/PriceInterface';

export interface IAviaBookingOrderPageData {
    /**
     * @example 'e4fb2374-388e-431e-ba8d-5de4b0683434'
     */
    orderId: string;
    state: OrderStateType;
    displayState: EDisplayOrderState;
    /**
     * @example '+79122996644'
     */
    phone: string;
    email: string;
    pnr?: string;
    price: IPrice;
    preliminaryPrice: IPrice;
    /**
     * Информация о пассажирах
     */
    travellers: ITravellerInfoDTO[];
    /**
     * Информация о перелетах.
     * Для One Way будет один элемент.
     * Для Round Trip два элемента.
     */
    segments: IBookingSegmentModel[];
    /**
     * @example 'YA-8544-2935-0864'
     */
    prettyOrderId: string;
    tripId?: string | null;
}
