import {IOrderDTO} from 'server/api/AviaBookingApi/types/IOrderDTO';
import {IBookingSegmentModel} from 'server/services/AviaBookingService/variants/types';
import {ISegmentDTO} from 'server/api/AviaBookingApi/types/ISegmentDTO';
import {IReferenceDTO} from 'server/api/AviaBookingApi/types/IReferenceDTO';

import {flightDTOtoFlightModel} from 'server/utilities/lib/avia/booking/flightDTOtoFlightModel';

import {IAviaBookingOrderPageData} from 'server/services/AviaBookingService/order/IAviaBookingOrderPageData';

function segmentFactory(
    {flights}: ISegmentDTO,
    reference: IReferenceDTO,
): IBookingSegmentModel {
    return {
        flights: flights.map(rawFlight =>
            flightDTOtoFlightModel(rawFlight, reference),
        ),
    };
}

export function orderDtoToPageModel(
    orderDTO: IOrderDTO,
): IAviaBookingOrderPageData {
    const {
        airReservation,
        travellers,
        state,
        edisplayOrderState,
        phone,
        price,
        email,
        reference,
        id,
        prettyId,
        preliminaryPrice,
        tripId,
    } = orderDTO;

    const {pnr, segments: rawSegments} = airReservation;

    const segments = rawSegments.map(rawSegment =>
        segmentFactory(rawSegment, reference),
    );

    return {
        orderId: id,
        prettyOrderId: prettyId,
        state,
        displayState: edisplayOrderState,
        phone,
        price,
        email,
        travellers,
        segments,
        pnr,
        preliminaryPrice,
        tripId,
    };
}
