import {
    IBookingPassengers,
    IBookingPriceInfo,
    IVariantPriceInfoDTO,
    TBookingPromoCampaigns,
} from 'server/api/AviaBookingApi/types/IBookingVariantsResponse';
import {IAirlineReferenceDTO} from 'server/api/AviaBookingApi/types/IAirlineReferenceDTO';
import {ISettlementReferenceDTO} from 'server/api/AviaBookingApi/types/ISettlementReferenceDTO';
import {IAirportReferenceDTO} from 'server/api/AviaBookingApi/types/IAirportReferenceDTO';
import {IBookingDateTime} from 'server/api/AviaBookingApi/types/IBookingDateTime';
import {ISegmentFare} from 'server/api/AviaBookingApi/types/ISegmentFare';
import {EAviaLoyaltyCardType} from 'types/avia/book/EAviaLoyaltyCardType';

export interface IBookingVariantsModelType {
    passengers: IBookingPassengers;
    priceInfo: IBookingPriceInfo;
    segments: IBookingSegmentModel[];
    allVariants: IBookingVariantModel[];
    qid: string;
    flightsByRoute: IBookingFlightsByRoute;
    orderUrl: string;
}

export interface IBookingVariantModel {
    id: string;
    promoCampaigns?: TBookingPromoCampaigns;
    priceInfo: IVariantPriceInfoDTO;
    segments: IBookingSegmentModel[];
    allowedLoyaltyPrograms: EAviaLoyaltyCardType[];
}

export interface IBookingSegmentModel {
    /**
     * Описывает информацию о перелетах.
     * Элементов может быть несколько в случае пересадок.
     */
    flights: IBookingFlightModel[];
}

type TBookingTariffAvailability = 'charge' | 'free' | 'not_available';

export interface IBookingTariffOptionType {
    type: string;
    shortDescription: string;
    fullDescription: string;
    availability: TBookingTariffAvailability;
}

export interface IBookingTariffBriefOptions {
    title: string;
    baggage: IBookingTariffOptionType | null;
    carryOn: IBookingTariffOptionType | null;
    miles: IBookingTariffOptionType | null;
    refund: IBookingTariffOptionType | null;
}

export interface IBookingFlightModel {
    id: string;
    flightNumber: string;
    /**
     * Маркетинговый перевозчик (от лица которого продаются билеты)
     */
    company: IAirlineReferenceDTO;
    /**
     * Оперирующий перевозчик (фактический перевозчик, на борту которого выполняется полет)
     */
    operatingCompany: IAirlineReferenceDTO;
    departureAirport: IAirportReferenceDTO;
    departureSettlement: ISettlementReferenceDTO;
    arrivalAirport: IAirportReferenceDTO;
    arrivalSettlement: ISettlementReferenceDTO;
    /**
     * @example '2022-02-25T17:30:00'
     */
    departureDate: string;
    /**
     * @example '2022-02-25T19:15:00'
     */
    arrivalDate: string;
    fareTerms: ISegmentFare;
}

export interface IBookingRouteFlight {
    to: number;
    key: string;
    from: number;
    number: string;
    arrival: IBookingDateTime;
    company: number;
    departure: IBookingDateTime;
    aviaCompany: number;
    companyTariff: number;
}

export interface IBookingFlightsByRoute {
    forward: IBookingRouteFlight[];
    backward: IBookingRouteFlight[];
}
