import {IAviaTDAnswer} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {parseFlights} from 'server/services/AviaFlightStorageService/utils/parseFlight';
import {decodeParams} from 'server/services/AviaFlightStorageService/utils/decodeParams';
import {convertFlightStorageData} from 'server/services/AviaFlightStorageService/utils/flightStorageDataConverter';

import {IDependencies} from 'server/getContainerConfig';
import {AviaFlightStorageApi} from 'server/api/AviaFlightStorageApi';

export class AviaFlightStorageService {
    private flightStorageApi: AviaFlightStorageApi;

    constructor({aviaFlightStorageApi}: IDependencies) {
        this.flightStorageApi = aviaFlightStorageApi;
    }

    async getOrder(params: {
        forward: string;
        backward?: string;
    }): Promise<IAviaTDAnswer | null> {
        const {forward, backward} = decodeParams(params);
        const forwardFlights = parseFlights(forward);
        const backwardFlights = parseFlights(backward);

        const flightsInfo = await Promise.all(
            [...forwardFlights, ...backwardFlights].map(flight =>
                this.flightStorageApi.flightDetailed(flight),
            ),
        );

        return convertFlightStorageData(
            forwardFlights,
            backwardFlights,
            flightsInfo,
        );
    }
}
